//+------------------------------------------------------------------+
//|                                            Vasily Pip Sniper.mq4 |
//|                                                            By: E |
//|                                             Bar version by V-X   |
//+------------------------------------------------------------------+
#property copyright "By: E"

//----
#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
#property indicator_width1 2
#property indicator_width2 2


extern int    TimeFrame = 0;
extern int    Price     = 6;
extern int    Method    = 3;
extern string estr      = "If UseUserVariables set to false, variables are automatically chosen";
extern bool   UseUserVariables = True;
extern int    FastPeriod = 21;
extern int    SlowPeriod = 144;
double alertBar;
double prev;
//---- parameters



int per1, per2;
//---- buffers
double up[];
double dn[];
double WorkBuffer[];
double WorkBuffer2[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//----
if (!UseUserVariables)
{
// for monthly
int mn_per = 12;
int mn_fast = 3;
// for weekly
int w_per = 9;
int w_fast = 3;
// for daily
int d_per = 5;
int d_fast = 3;
// for H4
int h4_per = 12;
int h4_fast = 2;
// for H1
int h1_per = 24;
int h1_fast = 8;
// for M30
int m30_per = 16;
int m30_fast = 2;
// for M15
int m15_per = 16;
int m15_fast = 4;
// for M5
int m5_per = 12;
int m5_fast = 3;
// for M1
int m1_per = 30;
int m1_fast = 10;
double alertTag;
//----
}  
//---- 
     if (UseUserVariables)
     {
     per1=SlowPeriod;
     per2=FastPeriod;
     }
     else
     {
      switch(Period())
     {
       case 1:     per1 = m1_per;  per2 = m1_fast;  break;
       case 5:     per1 = m5_per;  per2 = m5_fast;  break;
       case 15:    per1 = m15_per; per2 = m15_fast; break;
       case 30:    per1 = m30_per; per2 = m30_fast; break;
       case 60:    per1 = h1_per;  per2 = h1_fast;  break;
       case 240:   per1 = h4_per;  per2 = h4_fast;  break;
       case 1440:  per1 = d_per;   per2 = d_fast;   break;
       case 10080: per1 = w_per;   per2 = w_fast;   break;
       case 43200: per1 = mn_per;  per2 = mn_fast;  break;
     } 
     }
    int Timef; 
    if(TimeFrame != 0)
    {
    Timef=TimeFrame;
    }
    else
    {
    Timef=Period();
    }
string Indicator_Name = "Vasily Pip Sniper ZL ("+Timef+"):    ";
//-----
IndicatorBuffers(4);
   SetIndexStyle(0, DRAW_HISTOGRAM,0,4);
   SetIndexBuffer(0, up);
    
   SetIndexStyle(1, DRAW_HISTOGRAM,0,4);
   SetIndexBuffer(1, dn); 
   
   SetIndexBuffer(2, WorkBuffer);
   SetIndexBuffer(3, WorkBuffer2);
   
   SetIndexDrawBegin(0, per1 + per2);
   SetIndexDrawBegin(1, per1 + per2);

   IndicatorShortName(Indicator_Name);
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int limit;
   int counted_bars = IndicatorCounted();
 
//---- 
   if(counted_bars < 0) 
       return(-1);
//---- 
   if(counted_bars > 0) 
       counted_bars -= 10;
   limit = Bars - counted_bars/Period();
//---- 
  for(int i = 0; i < limit; i++)
       {
       WorkBuffer[i] = iMA(NULL, TimeFrame, per1, 0, Method, Price, i);
       WorkBuffer2[i]= iMA(NULL, TimeFrame, per2, 0, Method, Price, i);
       }
       
       for(i = 0; i < limit; i++)
       {
       double wMA, wMA2, lMA, sMA, pr;
     
       wMA = iMAOnArray(WorkBuffer, TimeFrame, per1, 0, Method, i);
       lMA = WorkBuffer[i] + WorkBuffer[i] - wMA;
     
       wMA2 = iMAOnArray(WorkBuffer2, TimeFrame, per2, 0, Method, i);
       sMA = WorkBuffer2[i] + WorkBuffer2[i] - wMA2;
       
       up[i]=sMA-lMA;
       dn[i]=lMA-sMA;
       
       if(up[i]>dn[i])
      {
         if (up[i]==1 && dn[i]==0 && Bars>alertBar)
         {
           Alert("Vasily Pip Sniper Trend Change LONG, ",Symbol()," ",Period());
         }
         up[i]=1;
         dn[i]=0;
          alertBar = Bars;prev = 2;         
      }
      else
      {

         if (up[i]==0 && dn[i]==1 && Bars>alertBar)
         {
           Alert("Vasily Pip Sniper Trend Change SHORT, ",Symbol()," ",Period());
         }
         up[i]=0;
         dn[i]=1;
          alertBar = Bars;prev = 1;
      }
       
      }
//----
   return(0);
  }
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+



